<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src\Listing\Listing;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Purchase extends Endpoint {

	public $action = 'utillz-purchase';

    public function action() {

		$response = [
			'success' => false
		];

		$data = (object) Ucore()->sanitize( $_POST );

		// no woocommerce
		if ( ! class_exists('woocommerce') ) {
			wp_send_json( array_merge( $response, [
				'message' => esc_html__( 'Please install WooCommerce in order to enable this action type', 'utillz-core' )
			]));
		}

		// check if logged in
		if ( ! is_user_logged_in() ) {
			wp_send_json( array_merge( $response, [
				'message' => esc_html__( 'Please signin to process the purchase', 'utillz-core' )
			]));
		}

		// check if owner
		if ( get_current_user_id() == get_post_field( 'post_author', $data->listing_id ) ) {
			wp_send_json( array_merge( $response, [
				'message' => esc_html__( 'You can\'t purchase your own item', 'utillz-core' )
			]));
		}

		// security check
		if ( ! isset( $data->security ) || ! wp_verify_nonce( $data->security, 'utillz-security-nonce' ) ) {
			wp_send_json( array_merge( $response, [
				'message' => esc_html__( 'Security check not passed', 'utillz-core' )
			]));
		}

		$listing = new Listing( $data->listing_id );
		$action = $listing->type->get_action('purchase');

		if( ! $listing->id ) {
			return;
		}

		// action type product
		$product = $listing->get_action_product('purchase');
		if( ! $product ) {
			wp_send_json( array_merge( $response, [
				'message' => esc_html__( 'Action type product is missing. Please edit the action type and select a WooCommerce product pf type `listing purchase`.', 'utillz-core' )
			]));
		}

		$pricing = $listing->get_pricing( isset( $data->addons ) ? $data->addons : [] );

		// has due amount -> add to cart
		if( $pricing->processing > 0 ) {

			if( apply_filters('utillz/cart/empty_cart', true) ) {
				WC()->cart->empty_cart();
			}

			WC()->cart->add_to_cart( $product->get_id(), 1, '', '', [
	            'listing_id' => [ $listing->id ],
	            'request_user_id' => get_current_user_id(),
				'pricing' => $pricing,
				'processing' => $pricing->processing,
	        ]);

			// go send user to pay
			wp_send_json([
				'success' => true,
				'redirect_url' => wc_get_checkout_url()
			]);

		}
		// no due amount -> process
		else{

			// create entry
			$entry_meta_input = [
				'ulz_entry_type' => 'purchase',
				'ulz_listing' => $listing->id,
				'ulz_request_user_id' => get_current_user_id(),
				'ulz_pricing' => wp_slash( json_encode( $pricing ) ),
			];

			$user = get_userdata( get_current_user_id() );

			$entry_id = wp_insert_post([
				'post_title' => $user->display_name,
				'post_status' => 'publish',
				'post_type' => 'ulz_entry',
				'post_author' => $listing->post->post_author,
				'meta_input' => $entry_meta_input
			]);

			if( ! is_wp_error( $entry_id ) ) {

				/*
				 * send notification
				 *
				 */
				utillz_core()->notify->distribute( 'new-purchase', [
					'user_id' => $listing->post->post_author,
					'meta' => [
						'entry_id' => $entry_id,
						'listing_id' => $listing->id,
						'from_user_id' => get_current_user_id(),
					],
				]);

				wp_send_json([
					'success' => true,
					'message' => esc_html__( 'Purchased successfully', 'utillz-core' )
				]);

			}
		}

	}

}
